<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Prestation extends Model 
{

    protected $table = 'prestations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id_user', 'id_category', 'name', 'minimu_price', 'id_device', 'banner', 'description', 'status', 'view');
    protected $visible = array('id_user', 'id_category', 'name', 'minimu_price', 'id_device', 'banner', 'description', 'status', 'view');

    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'id_category');
    }

    public function certifications()
    {
        return $this->morphMany('App\Models\Certification', 'certifiable_id');
    }

}